#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
#include <unordered_set>

using namespace std;

const int MAXN = 500000;

vector<int> graph[MAXN];
int values[MAXN];

void bfs(int start, unordered_set<int>& reachable) {
    queue<int> q;
    q.push(start);
    reachable.insert(start);
    
    while (!q.empty()) {
        int node = q.front();
        q.pop();
        for (int neighbor : graph[node]) {
            if (reachable.find(neighbor) == reachable.end()) {
                reachable.insert(neighbor);
                q.push(neighbor);
            }
        }
    }
}

int median(vector<int>& values) {
    sort(values.begin(), values.end());
    int m = values.size();
    return values[(m - 1) / 2];
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int N, M, Q, P;
    cin >> N >> M >> Q >> P;

    for (int i = 0; i < N; i++) {
        cin >> values[i];
    }

    for (int i = 0; i < M; i++) {
        int u, v;
        cin >> u >> v;
        u--; v--;
        graph[u].push_back(v);
        graph[v].push_back(u);
    }

    int a_ans = 0, b_ans = 0;
    for (int i = 0; i < Q; i++) {
        int a1, b1;
        cin >> a1 >> b1;
        int a = (a1 + a_ans * (P - 1)) % N;
        int b = (b1 + b_ans * (P - 1)) % N;

        unordered_set<int> reachable;
        bfs(a, reachable);

        vector<int> path_values;
        for (int node : reachable) {
            path_values.push_back(values[node]);
        }

        if (reachable.find(b) != reachable.end()) {
            b_ans = median(path_values);
        } else {
            b_ans = -1;
        }

        a_ans = median(path_values);
        cout << a_ans << "\n";
    }

    return 0;
}